/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

public class CECConstants {
    private static final String[] cecAddresses = new String[]{"TV", "REC1", "REC2", "TUNE1", "PLAY1", "AUDIO", "TUNE2", "TUNE3", "PLAY2", "REC3", "TUNE4", "PLAY3", "RSVD", "RSVD", "FREE", "*ALL*"};

    public static final String getCECAddressName(int n) {
        if (n > 15) {
            return "ERR!";
        }
        return cecAddresses[n];
    }

    public static final String getCECOpcodeName(int n) {
        switch (n) {
            case 0: {
                return "Feature Abort";
            }
            case 4: {
                return "Image View On";
            }
            case 5: {
                return "Tuner Step Increment";
            }
            case 6: {
                return "Tuner Step Decrement";
            }
            case 7: {
                return "Tuner Device Status";
            }
            case 8: {
                return "Give Tuner Device Status";
            }
            case 9: {
                return "Record On";
            }
            case 10: {
                return "Record Status";
            }
            case 11: {
                return "Record Off";
            }
            case 13: {
                return "Text View On";
            }
            case 15: {
                return "Record TV Screen";
            }
            case 26: {
                return "Give Deck Status";
            }
            case 27: {
                return "Deck Status";
            }
            case 50: {
                return "Set Menu Language";
            }
            case 51: {
                return "Clear Analogue Timer";
            }
            case 52: {
                return "Set Analogue Timer";
            }
            case 53: {
                return "Timer Status";
            }
            case 54: {
                return "Standby";
            }
            case 65: {
                return "Play";
            }
            case 66: {
                return "Deck Control";
            }
            case 67: {
                return "Timer Cleared Status";
            }
            case 68: {
                return "User Control Pressed";
            }
            case 69: {
                return "User Control Released";
            }
            case 70: {
                return "Give OSD Name";
            }
            case 71: {
                return "Set OSD Name";
            }
            case 100: {
                return "Set OSD String";
            }
            case 103: {
                return "Set Timer Program Title";
            }
            case 112: {
                return "System Audio Mode Request";
            }
            case 113: {
                return "Give Audio Status";
            }
            case 114: {
                return "Set System Audio Mode";
            }
            case 122: {
                return "Report Audio Status";
            }
            case 125: {
                return "Give System Audio Mode Status";
            }
            case 126: {
                return "System Audio Mode Status";
            }
            case 128: {
                return "Routing Change";
            }
            case 129: {
                return "Routing Information";
            }
            case 130: {
                return "Active Source";
            }
            case 131: {
                return "Give Physical Address";
            }
            case 132: {
                return "Report Physical Address";
            }
            case 133: {
                return "Request Active Source";
            }
            case 134: {
                return "Set Stream Path";
            }
            case 135: {
                return "Device Vendor ID";
            }
            case 137: {
                return "Vendor Command";
            }
            case 138: {
                return "Vendor Remote Button Down";
            }
            case 139: {
                return "Vendor Remote Button Up";
            }
            case 140: {
                return "Give Vendor ID";
            }
            case 141: {
                return "Menu Request";
            }
            case 142: {
                return "Menu Status";
            }
            case 143: {
                return "Give Device Power Status";
            }
            case 144: {
                return "Report Power Status";
            }
            case 145: {
                return "Get Menu Language";
            }
            case 146: {
                return "Select Analogue Service";
            }
            case 147: {
                return "Select Digital Service";
            }
            case 151: {
                return "Set Digital Timer";
            }
            case 153: {
                return "Clear Digital Timer";
            }
            case 154: {
                return "Set Audio Rate";
            }
            case 157: {
                return "Inactive Source";
            }
            case 158: {
                return "CEC Version";
            }
            case 159: {
                return "Get CEC Version";
            }
            case 160: {
                return "Vendor Command With ID";
            }
            case 161: {
                return "Clear External Timer";
            }
            case 162: {
                return "Set External Timer";
            }
            case 255: {
                return "Abort";
            }
        }
        return "Unsupported CEC Code 0x" + Integer.toHexString(n);
    }

    public static final boolean isLegalOpcode(int n) {
        switch (n) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 26: 
            case 27: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 100: 
            case 103: 
            case 112: 
            case 113: 
            case 114: 
            case 122: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 151: 
            case 153: 
            case 154: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 255: {
                return true;
            }
        }
        return false;
    }

    public static final String getAbortReason(int n) {
        switch (n) {
            case 0: {
                return "Unrecognized Opcode";
            }
            case 1: {
                return "Not in correct mode to respond";
            }
            case 2: {
                return "Cannot provide source";
            }
            case 3: {
                return "Invalid operand";
            }
            case 4: {
                return "Refused";
            }
        }
        return "Invalid Abort Reason 0x" + Integer.toHexString(n);
    }

    public static final String getASCIIDigit(int n) {
        if (n >= 48 && n <= 57) {
            return String.format("%c", Character.valueOf((char)n));
        }
        return "?";
    }

    public static final String getASCII(int n) {
        if (n >= 32 && n <= 127) {
            return String.format("%c", Character.valueOf((char)n));
        }
        return "?";
    }

    public static final String getBoolean(int n) {
        switch (n) {
            case 0: {
                return "False";
            }
            case 1: {
                return "True";
            }
        }
        return "Invalid Boolean value 0x" + Integer.toHexString(n);
    }

    public static final String getDeckControlMode(int n) {
        switch (n) {
            case 1: {
                return "Skip Forward / Wind Forward";
            }
            case 2: {
                return "Skip Backward / Rewind";
            }
            case 3: {
                return "Stop";
            }
            case 4: {
                return "Eject";
            }
        }
        return "Invalid Deck Control Mode 0x" + Integer.toHexString(n);
    }

    public static final String getDeckInfo(int n) {
        switch (n) {
            case 17: {
                return "Play";
            }
            case 18: {
                return "Record";
            }
            case 19: {
                return "Play Reverse";
            }
            case 20: {
                return "Still";
            }
            case 21: {
                return "Slow";
            }
            case 22: {
                return "Slow Reverse";
            }
            case 23: {
                return "Search Forward";
            }
            case 24: {
                return "Search Reverse";
            }
            case 25: {
                return "No Media";
            }
            case 26: {
                return "Stop";
            }
            case 27: {
                return "Wind";
            }
            case 28: {
                return "Rewind";
            }
            case 29: {
                return "Index Search Forward";
            }
            case 30: {
                return "Index Search Reverse";
            }
            case 31: {
                return "Other Status";
            }
        }
        return "Invalid Deck Info value 0x" + Integer.toHexString(n);
    }

    public static final String getDeviceType(int n) {
        switch (n) {
            case 0: {
                return "TV";
            }
            case 1: {
                return "Recording Device";
            }
            case 3: {
                return "STB";
            }
            case 4: {
                return "DVD";
            }
            case 5: {
                return "Audio System";
            }
        }
        return "Unknown Device Type " + n;
    }

    public static final String getDisplayControl(int n) {
        return ((n & 0x40) == 0 ? "Display for Default Time" : "Display Until Cleared") + " / " + ((n & 0x80) == 0 ? "Clear Previous Message" : "Reserved");
    }

    public static final String getMenuRequestType(int n) {
        switch (n) {
            case 0: {
                return "Activate";
            }
            case 1: {
                return "Deactivate";
            }
            case 2: {
                return "Query";
            }
        }
        return "Invalid Menu Request Type 0x" + Integer.toHexString(n);
    }

    public static final String getSystemAudioStatus(int n) {
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Invalid System Audio Status 0x" + Integer.toHexString(n);
    }

    public static final String getMenuState(int n) {
        switch (n) {
            case 0: {
                return "Activated";
            }
            case 1: {
                return "Deactivated";
            }
        }
        return "Invalid Menu State 0x" + Integer.toHexString(n);
    }

    public static final String getPlayMode(int n) {
        switch (n) {
            case 36: {
                return "Play Forward";
            }
            case 32: {
                return "Play Reverse";
            }
            case 37: {
                return "Play Still (Pause)";
            }
            case 5: {
                return "Scan Forward Min Speed";
            }
            case 6: {
                return "Scan Forward Med Speed";
            }
            case 7: {
                return "Scan Forward Max Speed";
            }
            case 9: {
                return "Scan Reverse Min Speed";
            }
            case 10: {
                return "Scan Reverse Med Speed";
            }
            case 11: {
                return "Scan Reverse Max Speed";
            }
            case 21: {
                return "Slow Forward Min Speed";
            }
            case 22: {
                return "Slow Forward Med Speed";
            }
            case 23: {
                return "Slow Forward Max Speed";
            }
            case 25: {
                return "Slow Reverse Min Speed";
            }
            case 26: {
                return "Slow Reverse Med Speed";
            }
            case 27: {
                return "Slow Reverse Max Speed";
            }
        }
        return "Unknown Play Mode 0x" + Integer.toHexString(n);
    }

    public static final String getRecStatusInfo(int n) {
        switch (n) {
            case 1: {
                return "Recording currently selected source";
            }
            case 2: {
                return "Recording Digital Service";
            }
            case 3: {
                return "Recording Analogue Service";
            }
            case 4: {
                return "Recording external input";
            }
            case 5: {
                return "No recording - Unable to record Digital Service";
            }
            case 6: {
                return "No recording - Unable to record Analogue Service";
            }
            case 7: {
                return "No recording - Unable to select required service";
            }
            case 9: {
                return "No recording - Invalid external plug number";
            }
            case 10: {
                return "No recording - Invalid external physical address";
            }
            case 11: {
                return "No recording - CA system not supported";
            }
            case 12: {
                return "No recording - No or insufficient CA Entitlements";
            }
            case 13: {
                return "No recording - Not allowed to copy source";
            }
            case 14: {
                return "No recording - No further copies allowed";
            }
            case 16: {
                return "No recording - No media";
            }
            case 17: {
                return "No recording - Playing";
            }
            case 18: {
                return "No recording - Already recording";
            }
            case 19: {
                return "No recording - Media protected";
            }
            case 20: {
                return "No recording - No source";
            }
            case 21: {
                return "No recording - Media problem";
            }
            case 22: {
                return "No recording - Not enough space available";
            }
            case 23: {
                return "No recording - Parental lock On";
            }
            case 26: {
                return "No recording - Recording terminated normally";
            }
            case 27: {
                return "No recording - Recording has already terminated";
            }
            case 31: {
                return "No recording - Other Reason";
            }
        }
        return "Unknown Record Status Info 0x" + Integer.toHexString(n);
    }

    public static final String getRecordingSequence(int n) {
        int n2;
        String string = Integer.toBinaryString(n);
        String string2 = "";
        for (n2 = string.length(); n2 < 8; ++n2) {
            string2 = string2 + "0";
        }
        string = string2 + string;
        string2 = "";
        if ((n & 0x7F) == 0) {
            if (string2.length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + "Only once";
        }
        for (n2 = 0; n2 < 8; ++n2) {
            if (string.charAt(n2) != '1') continue;
            if (string2.length() > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + CECConstants.getRecordingSequenceIndexVal(n2);
        }
        return string2;
    }

    public static final String getRecordingSequenceIndexVal(int n) {
        switch (n) {
            case 0: {
                return "Reserved bit set";
            }
            case 1: {
                return "Saturday";
            }
            case 2: {
                return "Friday";
            }
            case 3: {
                return "Thursday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Tuesday";
            }
            case 6: {
                return "Monday";
            }
            case 7: {
                return "Sunday";
            }
        }
        return "";
    }

    public static final String getPowerStatus(int n) {
        switch (n) {
            case 0: {
                return "On";
            }
            case 1: {
                return "Standby";
            }
            case 2: {
                return "In Transition, Standby to On";
            }
            case 3: {
                return "In Transition, On to Standby";
            }
        }
        return "Unknown Power Mode " + n;
    }

    public static final String getStatusRequest(int n) {
        switch (n) {
            case 1: {
                return "On";
            }
            case 2: {
                return "Off";
            }
            case 3: {
                return "Once";
            }
        }
        return "Unknown Status Request " + n;
    }

    public static final String getAnalogBroadcastSystem(int n) {
        switch (n) {
            case 0: {
                return "PAL-B/G";
            }
            case 1: {
                return "SECAM-L";
            }
            case 2: {
                return "PAL-M";
            }
            case 3: {
                return "NTSC-M";
            }
            case 4: {
                return "PAL-I";
            }
            case 5: {
                return "SECAM-DK";
            }
            case 6: {
                return "SECAM-B/G";
            }
            case 7: {
                return "SECAM-L";
            }
            case 8: {
                return "PAL-DK";
            }
            case 31: {
                return "Other System";
            }
        }
        return "Future use (reserved)";
    }

    public static final double getAnalogFrequency(int n) {
        return (double)n * 0.0625;
    }

    public static final String getAudioRate(int n) {
        switch (n) {
            case 0: {
                return "Rate Control Off";
            }
            case 1: {
                return "Standard Rate (100% rate) - Wide Range Control";
            }
            case 2: {
                return "Fast Rate (Max 101% rate) - Wide Range Control";
            }
            case 3: {
                return "Slow Rate (Min 99% rate) - Wide Range Control";
            }
            case 4: {
                return "Standard Rate (100.0% rate) - Narrow Range Control";
            }
            case 5: {
                return "Fast Rate (Max 100.1% rate) - Narrow Range Control";
            }
            case 6: {
                return "Slow Rate (Min 99.9% rate) - Narrow Range Control";
            }
        }
        return "Future use (reserved)";
    }

    public static final String getAudioStatus(int n) {
        String string = "Audio Mute ";
        string = (n & 0x80) == 128 ? string + "On" : string + "Off";
        string = string + ", Volume level: ";
        string = (n &= 0x7F) < 101 ? string + n + "%" : (n == 127 ? string + "Unknown" : string + "Reserved value");
        return string;
    }

    public static final String getCECVersion(int n) {
        String string = "Version 1.";
        switch (n) {
            case 0: {
                string = string + "1";
                break;
            }
            case 1: {
                string = string + "2";
                break;
            }
            case 2: {
                string = string + "2a";
                break;
            }
            case 3: {
                string = string + "3";
                break;
            }
            case 4: {
                string = string + "3a";
                break;
            }
            default: {
                return "Future use (reserved)";
            }
        }
        return string;
    }

    public static final String getExternalSourceSpecifier(int n) {
        switch (n) {
            case 4: {
                return "External Plug";
            }
            case 5: {
                return "External Physical Address";
            }
        }
        return "Future use (reserved)";
    }

    public static final String getTimerClearedStatusData(int n) {
        switch (n) {
            case 0: {
                return "Timer not cleared - recording";
            }
            case 1: {
                return "Timer not cleared - no match";
            }
            case 2: {
                return "Timer not cleared - no info available";
            }
            case 128: {
                return "Timer cleared";
            }
        }
        return "Future use (reserved)";
    }

    public static final String getUserControlCode(int n) {
        if (n >= 32 && n <= 41) {
            return "Number " + (n - 32);
        }
        switch (n) {
            case 0: {
                return "Select";
            }
            case 1: {
                return "Up";
            }
            case 2: {
                return "Down";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
            case 5: {
                return "Right-Up";
            }
            case 6: {
                return "Right-Down";
            }
            case 7: {
                return "Left-Up";
            }
            case 8: {
                return "Left-Down";
            }
            case 9: {
                return "Root Menu";
            }
            case 10: {
                return "Setup Menu";
            }
            case 11: {
                return "Contents Menu";
            }
            case 12: {
                return "Favorites Menu";
            }
            case 13: {
                return "Exit";
            }
            case 42: {
                return "Dot";
            }
            case 43: {
                return "Enter";
            }
            case 44: {
                return "Clear";
            }
            case 47: {
                return "Next Favorite";
            }
            case 48: {
                return "Channel Up";
            }
            case 49: {
                return "Channel Down";
            }
            case 50: {
                return "Previous Channel";
            }
            case 51: {
                return "Sound Select";
            }
            case 52: {
                return "Input Select";
            }
            case 53: {
                return "Display Information";
            }
            case 54: {
                return "Help";
            }
            case 55: {
                return "Page Up";
            }
            case 56: {
                return "Page Down";
            }
            case 64: {
                return "Power";
            }
            case 65: {
                return "Volume Up";
            }
            case 66: {
                return "Volume Down";
            }
            case 67: {
                return "Mute";
            }
            case 68: {
                return "Play";
            }
            case 69: {
                return "Stop";
            }
            case 70: {
                return "Pause";
            }
            case 71: {
                return "Record";
            }
            case 72: {
                return "Rewind";
            }
            case 73: {
                return "Fast Forward";
            }
            case 74: {
                return "Eject";
            }
            case 75: {
                return "Forward";
            }
            case 76: {
                return "Backward";
            }
            case 77: {
                return "Stop-Record";
            }
            case 78: {
                return "Pause-Record";
            }
            case 80: {
                return "Angle";
            }
            case 81: {
                return "Sub-picture";
            }
            case 82: {
                return "Video on Demand";
            }
            case 83: {
                return "Electronic Programming Guide";
            }
            case 84: {
                return "Timer Programming";
            }
            case 85: {
                return "Initial Configuration";
            }
            case 96: {
                return "Play Function";
            }
            case 97: {
                return "Pause-Play Function";
            }
            case 98: {
                return "Record Function";
            }
            case 99: {
                return "Pause-Record Function";
            }
            case 100: {
                return "Stop Function";
            }
            case 101: {
                return "Mute Function";
            }
            case 102: {
                return "Restore Volume Function";
            }
            case 103: {
                return "Tune Function";
            }
            case 104: {
                return "Select Media Function";
            }
            case 105: {
                return "Select A/V Input Function";
            }
            case 106: {
                return "Select Audio Input Function";
            }
            case 107: {
                return "Power Toggle Function";
            }
            case 108: {
                return "Power Off Function";
            }
            case 109: {
                return "Power On Function";
            }
            case 113: {
                return "F1 (Blue)";
            }
            case 114: {
                return "F2 (Red)";
            }
            case 115: {
                return "F3 (Green)";
            }
            case 116: {
                return "F4 (Yellow)";
            }
            case 117: {
                return "F5";
            }
            case 118: {
                return "Data";
            }
        }
        return "Reserved 0x" + Integer.toHexString(n);
    }

    public static final String getTimerStatusData(int n) {
        String string = ((n & 0x80) == 0 ? "No overlap" : "Timer blocks overlap") + ", " + CECConstants.getMediaInfo(n >> 5 & 3) + ", ";
        if ((n & 0x10) == 0) {
            string = string + "Not programmed (";
            string = string + CECConstants.getNotProgrammedErrorInfo(n & 0xF);
        } else {
            string = string + "Programmed (";
            string = string + CECConstants.getProgrammedInfo(n & 0xF);
        }
        string = string + ")";
        return string;
    }

    public static final String getMediaInfo(int n) {
        switch (n) {
            case 0: {
                return "Media present and not protected";
            }
            case 1: {
                return "Media present, but protected";
            }
            case 2: {
                return "Media not present";
            }
        }
        return "Future use (reserved)";
    }

    public static final String getDigitalBroadcastSystem(int n) {
        switch (n) {
            case 0: {
                return "ARIB (Generic)";
            }
            case 1: {
                return "ATSC (Generic)";
            }
            case 2: {
                return "DVB (Generic)";
            }
            case 8: {
                return "ARIB-BS";
            }
            case 9: {
                return "ARIB-CS";
            }
            case 10: {
                return "ARIB-T";
            }
            case 16: {
                return "ATSC (Cable)";
            }
            case 17: {
                return "ATSC (Satellite)";
            }
            case 18: {
                return "ATSC (Terrestrial)";
            }
            case 24: {
                return "DVB-C";
            }
            case 25: {
                return "DVB-S";
            }
            case 26: {
                return "DVB S2";
            }
            case 27: {
                return "DVB-T";
            }
        }
        return "Future use (reserved)";
    }

    public static final String getAnalogBroadcastType(int n) {
        switch (n) {
            case 0: {
                return "Cable";
            }
            case 1: {
                return "Satellite";
            }
            case 2: {
                return "Terrestrial";
            }
        }
        return "Future use (reserved)";
    }

    public static final String getProgrammedInfo(int n) {
        switch (n) {
            case 8: {
                return "Enough space available for recording";
            }
            case 9: {
                return "Not enough space available for recording";
            }
            case 10: {
                return "No media info available";
            }
            case 11: {
                return "May not be enough space available";
            }
        }
        return "Future use (reserved)";
    }

    public static final String getNotProgrammedErrorInfo(int n) {
        switch (n) {
            case 1: {
                return "No free timer available";
            }
            case 2: {
                return "Date out of range";
            }
            case 3: {
                return "Recording sequence error";
            }
            case 4: {
                return "Invalid external plug number";
            }
            case 5: {
                return "Invalid external physical address";
            }
            case 6: {
                return "CA system not supported";
            }
            case 7: {
                return "No or insufficient CA Entitlements";
            }
            case 8: {
                return "Does not support resolution";
            }
            case 9: {
                return "Parental lock On";
            }
            case 10: {
                return "Clock failure";
            }
            case 14: {
                return "Duplicate (already programmed)";
            }
        }
        return "Future use (reserved)";
    }

    public static final boolean isBroadcast(int n) {
        switch (n) {
            case 50: 
            case 54: 
            case 114: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 138: 
            case 139: 
            case 160: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isDirected(int n) {
        switch (n) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 26: 
            case 27: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 100: 
            case 103: 
            case 112: 
            case 113: 
            case 114: 
            case 122: 
            case 125: 
            case 126: 
            case 131: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 151: 
            case 153: 
            case 154: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 255: {
                return true;
            }
        }
        return false;
    }

    public static final int convertBCDtoDecimal(int n) {
        int n2 = n & 0xF;
        if (n2 > 9) {
            return 100;
        }
        return n2 + (n >> 4 & 0xF) * 10;
    }
}

